package com.gc.nfc;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import com.gc.nfc.ui.ReadCardInfoActivity;
import com.gc.nfc.ui.ReadMUActivity;
import com.gc.nfc.ui.ReadTextActivity;
import com.gc.nfc.ui.ReadUriActivity;
import com.gc.nfc.ui.RunAppActivity;
import com.gc.nfc.ui.RunUrlActivity;
import com.gc.nfc.ui.WriteMUActivity;
import com.gc.nfc.ui.WriteTextActivity;
import com.gc.nfc.ui.WriteUriActivity;

public class MainActivity extends AppCompatActivity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        ListView listView = (ListView) findViewById(R.id.listview);
        listView.setAdapter(new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, getSourceStr(this)));
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                switchActivity(position);
            }
        });
    }

    private String[] getSourceStr(Context context) {
        return new String[]{
                context.getResources().getString(R.string.str_run_app),
                context.getResources().getString(R.string.str_run_url),
                context.getResources().getString(R.string.str_read_text),
                context.getResources().getString(R.string.str_write_text),
                context.getResources().getString(R.string.str_read_uri),
                context.getResources().getString(R.string.str_write_uri),
                context.getResources().getString(R.string.str_read_mu),
                context.getResources().getString(R.string.str_write_mu),
                context.getResources().getString(R.string.str_read_info),
        };
    }

    private void switchActivity(int position) {
        switch (position) {
            case 0: //Run the program automatically(NDEF)
                //startActivity(new Intent(this, RunAppActivity.class));
                break;
            case 1: //Open web page automatically(NDEF)
                //startActivity(new Intent(this, RunUrlActivity.class));
                break;
            case 2: //Read text data in NFC tag(NDEF)
                startActivity(new Intent(this, ReadTextActivity.class));
                break;
            case 3: //Write text data in NFC tag(NDEF)
//                startActivity(new Intent(this, WriteTextActivity.class));
                break;
            case 4: //Read URI data in NFC tag(NDEF)
                startActivity(new Intent(this, ReadUriActivity.class));
                break;
            case 5: //Write URI data in NFC tag(NDEF)
//                startActivity(new Intent(this, WriteUriActivity.class));
                break;
            case 6: //Read NFC label data in non nDef format
                startActivity(new Intent(this, ReadMUActivity.class));
                break;
            case 7: //Write NFC label data in non nDef format
//                startActivity(new Intent(this, WriteMUActivity.class));
                break;
            case 8: //read card info
                startActivity(new Intent(this, ReadCardInfoActivity.class));
                break;
            default:
                break;
        }
    }
}
