package com.gc.nfc.base;

import android.app.PendingIntent;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.support.v7.app.AppCompatActivity;

/**
 * 1.Subclass needs to initialize activity in oncreate method.
 * 2.Subclasses need to perform NFC tag related operations in the onnewintent method.
 * When the launchmode is set to singletop, the oncreate method is called in the first run,
 * and the onnewintent method will not be called in the second run. Therefore,
 * we get the tag data passed by the intent and execute it in the onnewintent method.
 * If there is already an instance of the activity in the stack, the instance will be reused
 * (the onnewintent () of the instance will be called) as long as the NFC Execute as soon as the label is near
 */
public class BaseNfcActivity extends AppCompatActivity {
    private NfcAdapter mNfcAdapter;
    private PendingIntent mPendingIntent;

    /**
     * When the activity is started and the interface is visible
     */
    @Override
    protected void onStart() {
        super.onStart();
        mNfcAdapter = NfcAdapter.getDefaultAdapter(this);
        //Once the NFC message is intercepted, the window will be called through pendingintent
        mPendingIntent = PendingIntent.getActivity(this, 0, new Intent(this, getClass()), 0);
    }

    /**
     * Get the focus and click the button
     */
    @Override
    public void onResume() {
        super.onResume();
        //Set processing is superior to all other NFC processing
        if (mNfcAdapter != null)
            mNfcAdapter.enableForegroundDispatch(this, mPendingIntent, null, null);
    }

    /**
     * Pause the activity and get the focus in the interface. You can click the button
     */
    @Override
    public void onPause() {
        super.onPause();
        //Restore default state
        if (mNfcAdapter != null)
            mNfcAdapter.disableForegroundDispatch(this);
    }
}
