package com.gc.nfc.ui;

import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import com.gc.nfc.R;
import com.gc.nfc.base.BaseNfcActivity;

import java.io.IOException;

public class ReadCardInfoActivity extends BaseNfcActivity {

    TextView cardIdDec, cardIdHex, infoTechnologiew;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_read_card_info);

        cardIdDec = (TextView) findViewById(R.id.tv_id_num);
        cardIdHex = (TextView) findViewById(R.id.tv_id_num_hex);
        infoTechnologiew = (TextView) findViewById(R.id.tech_available);
    }

    @Override
    public void onNewIntent(Intent intent) {
        //获取到卡对象
        Tag tagFromIntent = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
        //获取卡id这里即uid，字节数组类型
        byte[] aa = tagFromIntent.getId();
//        byte[] aa = new byte[]{(byte)0xD4, (byte)0x5F, (byte)0xE4, (byte)0x1E};
        long aaResult = 0;
        for(int i = 0; i < aa.length; i++){
            aaResult = aaResult | ((long)(aa[i] & 0xff) << (i * 8));

        }
        Log.e("TAG",  "aaResult:" + aaResult);
        //字节数组转十六进制字符串
        String str = bytesToHexString(aa);
//        String str = "D45FE41E";
        if (str == null) return;
        int length = str.length();
        if (length%2 != 0) return;

        cardIdDec.setText(str);
        String result = String.valueOf(aaResult);
        cardIdHex.setText(result.length() % 2 != 0 ? "0" + result : result);

        String[] techList = tagFromIntent.getTechList();
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String tech : techList) {
            if (count > 0) builder.append(",");
            if (!tech.isEmpty() && tech.indexOf(".") > 0) {
                int index = tech.lastIndexOf(".") + 1;
                builder.append(tech.substring(index));
            }
            count++;
        }
        infoTechnologiew.setText(builder.toString());


    }

    /**
     * 字节数组转为十六进制
     */
    public static String bytesToHexString(byte[] src) {
        if (src == null || src.length <= 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < src.length; i++) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString().toUpperCase();

    }
}
