package com.gc.nfc.ui;

import android.content.Intent;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.Ndef;
import android.os.Parcelable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.widget.TextView;

import com.gc.nfc.R;
import com.gc.nfc.base.BaseNfcActivity;

import java.io.IOException;
import java.util.Arrays;

public class ReadTextActivity extends BaseNfcActivity {
    private TextView mNfcText;
    private String mTagText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_read_text);
        mNfcText = (TextView) findViewById(R.id.tv_nfctext);
    }

    @Override
    public void onNewIntent(Intent intent) {
        //1.Get tag object
        Tag detectedTag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
        //2.Get Ndef object
        Ndef ndef = Ndef.get(detectedTag);
        if (ndef == null) return;
        mTagText = ndef.getType() + "\nmaxsize:" + ndef.getMaxSize() + "bytes\n\n";
        try {
            readNfcTag(intent);
        } catch (IOException e) {
            e.printStackTrace();
        }
        mNfcText.setText(mTagText);
    }

    /**
     * Read NFC label text data
     */
    private void readNfcTag(Intent intent) throws IOException {
        if (NfcAdapter.ACTION_NDEF_DISCOVERED.equals(intent.getAction())) {
            Parcelable[] rawMsgs = intent.getParcelableArrayExtra(
                    NfcAdapter.EXTRA_NDEF_MESSAGES);
            NdefMessage msgs[] = null;
            int contentSize = 0;
            if (rawMsgs != null) {
                msgs = new NdefMessage[rawMsgs.length];
                for (int i = 0; i < rawMsgs.length; i++) {
                    msgs[i] = (NdefMessage) rawMsgs[i];
                    contentSize += msgs[i].toByteArray().length;
                }
            }
            try {
                if (msgs != null) {
                    NdefRecord record = msgs[0].getRecords()[0];
                    String textRecord = parseTextRecord(record);
                    if (!TextUtils.isEmpty(textRecord)) {
                        contentSize = textRecord.length();
                    }
                    mTagText += this.getResources().getString(R.string.will_read_text) + textRecord + "\n\ntext\n" + contentSize + " bytes";
                }
            } catch (Exception e) {
            }
        }


        /*byte[] key = {(byte) 0xA0, (byte) 0xB7, (byte) 0xA5, (byte) 0xC5, (byte) 0x80, (byte) 0x88};
        Tag tag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
        //加密IC卡
        MifareClassic mifareClassic = MifareClassic.get(tag);
        mifareClassic.connect();
        //获取扇区数量
        int count = mifareClassic.getSectorCount();
        //判断是否为默认密码
        boolean isOpen = mifareClassic.authenticateSectorWithKeyA(1, MifareClassic.KEY_DEFAULT);
        if (isOpen) {
            //加密
            int bCount = mifareClassic.getBlockCountInSector(1);
            int bIndex = mifareClassic.sectorToBlock(1);
            for (int j = 0; j < bCount; j++) {
                //修改KeyA和KeyB
                if ((bIndex + j) == 7) {
                    mifareClassic.writeBlock(bIndex + j, new byte[]{(byte) 0xa0, (byte) 0xb7, (byte) 0xa5, (byte) 0xc5, (byte) 0x80, (byte) 0x88, (byte) 0xff, 0x07, (byte) 0x80, (byte) 0x69, (byte) 0xa0, (byte) 0xb7, (byte) 0xa5, (byte) 0xc5, (byte) 0x80, (byte) 0x88});
                }
            }
        } else {
            //解密
            boolean isPassword = mifareClassic.authenticateSectorWithKeyA(1, key);
            if (isPassword) {
                Log.e("onNewIntent:", "密码正确");
            }
        }*/
    }

    /**
     * Parse NDEF text data, starting from the third byte, followed by text data
     *
     * @param ndefRecord
     * @return
     */
    public static String parseTextRecord(NdefRecord ndefRecord) {
        /**
         * Determine whether the data is in nDef format
         */
        //Judge TNF
        if (ndefRecord.getTnf() != NdefRecord.TNF_WELL_KNOWN) {
            return null;
        }
        //Determine the type of variable length
        if (!Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_TEXT)) {
            return null;
        }
        try {
            //Get the byte array and analyze it
            byte[] payload = ndefRecord.getPayload();
            //Next, start with the first byte of nDef text data, the status byte
            //To determine whether the text is based on UTF-8 or utf-16, take the first byte "bit and" on the hexadecimal 80,
            // the hexadecimal 80, that is, the highest bit is 1, other bits are 0, so the "bit and" operation will retain the highest bit
            String textEncoding = ((payload[0] & 0x80) == 0) ? "UTF-8" : "UTF-16";
            //The highest two bits of 3F are 0 and the sixth bit is 1, so the sixth bit is obtained after bit and operation
            int languageCodeLength = payload[0] & 0x3f;
            //Let's start with the second byte of nDef text data, language encoding
            //Get language coding
            String languageCode = new String(payload, 1, languageCodeLength, "US-ASCII");
            //Next, start the byte after nDef text data to parse the text
            String textRecord = new String(payload, languageCodeLength + 1,
                    payload.length - languageCodeLength - 1, textEncoding);
            return textRecord;
        } catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}
