package com.gc.nfc.ui;

import android.content.Intent;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

import com.gc.nfc.R;
import com.gc.nfc.base.BaseNfcActivity;

public class RunAppActivity extends BaseNfcActivity {
    private String mPackageName = "com.android.mms";//short message

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_run_app);
    }

    @Override
    public void onNewIntent(Intent intent) {
        if (mPackageName == null)
            return;
        //1.Get tag object
        Tag detectedTag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
        writeNFCTag(detectedTag);
    }

    /**
     * How to write data to label
     *
     * @param tag
     */
    public void writeNFCTag(Tag tag) {
        if (tag == null) {
            return;
        }
        NdefMessage ndefMessage = new NdefMessage(new NdefRecord[]{NdefRecord
                .createApplicationRecord(mPackageName)});
        //Convert to byte to get size
        int size = ndefMessage.toByteArray().length;
        NdefRecord[] ndefMessage1 = ndefMessage.getRecords();
        for (NdefRecord record : ndefMessage1) {
            String str = record.toString();
            Log.d("tt", str);
        }
        //2.Determine the data type of NFC tag (by Ndef.get Methods)
        Ndef ndef = Ndef.get(tag);
        NdefFormatable format = null;
        try {
            //Determine whether it is an NDEF label
            if (ndef != null) {
                ndef.connect();
                //Determine whether it supports writable
                if (!ndef.isWritable()) {
                    return;
                }
                //Judge whether the capacity of the label is enough
                if (ndef.getMaxSize() < size) {
                    return;
                }
                //3.Write data
                ndef.writeNdefMessage(ndefMessage);
                Toast.makeText(this, this.getResources().getString(R.string.write_success), Toast.LENGTH_SHORT).show();
            } else { //When we buy NFC tags that are not formatted or partitioned, perform this step
                //NDef format class
                format = NdefFormatable.get(tag);
                //Determine whether the ndefformatable object is obtained. Some tags are read-only or not allowed to be formatted
                if (format != null) {
                    //connect
                    format.connect();
                    //Format and write the information to the label
                    format.format(ndefMessage);
                    format.close();
                    Toast.makeText(this, this.getResources().getString(R.string.write_success), Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(this, this.getResources().getString(R.string.write_failed), Toast.LENGTH_SHORT).show();
                }
            }
        } catch (Exception e) {
        } finally {
            try {
                ndef.close();
            } catch (Exception e) {
            }
            try {
                if (format != null) {
                    format.close();
                }
            } catch (Exception e) {
            }

        }
    }
}