package com.gc.nfc.ui;

import android.content.Intent;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.os.Bundle;
import android.widget.Toast;

import com.gc.nfc.R;
import com.gc.nfc.base.BaseNfcActivity;

public class RunUrlActivity extends BaseNfcActivity {
    private String mUri = "https://www.hao123.com/";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_run_url);
    }

    @Override
    public void onNewIntent(Intent intent) {
        //1.Get tag object
        Tag detectedTag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
        writeNFCTag(detectedTag);
    }

    /**
     * How to write data to label
     *
     * @param tag
     */
    public void writeNFCTag(Tag tag) {
        if (tag == null) {
            return;
        }
        NdefMessage ndefMessage = new NdefMessage(new NdefRecord[]{NdefRecord
                .createUri(Uri.parse(mUri))});
        //Convert to byte to get size
        int size = ndefMessage.toByteArray().length;
        //2.Determine the data type of NFC tag (by Ndef.get Methods)
        Ndef ndef = Ndef.get(tag);
        NdefFormatable format = null;
        try {
            //Determine whether it is an NDEF label
            if (ndef != null) {
                //connect
                ndef.connect();
                //Determine whether it supports writable
                if (!ndef.isWritable()) {
                    return;
                }
                //Judge whether the capacity of the label is enough
                if (ndef.getMaxSize() < size) {
                    return;
                }
                //3.Write data
                ndef.writeNdefMessage(ndefMessage);
                Toast.makeText(this, this.getResources().getString(R.string.write_success), Toast.LENGTH_SHORT).show();
            } else { //When we buy NFC tags that are not formatted or partitioned, perform this step
                //NDef format class
                format = NdefFormatable.get(tag);
                //Determine whether the ndefformatable object is obtained. Some tags are read-only or not allowed to be formatted
                if (format != null) {
                    //connect
                    format.connect();
                    //Format and write the information to the label
                    format.format(ndefMessage);
                    Toast.makeText(this, this.getResources().getString(R.string.write_success),
                            Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(this, this.getResources().getString(R.string.write_failed), Toast.LENGTH_SHORT).show();
                }
            }
        } catch (Exception e) {
        } finally {
            try {
                ndef.close();
            } catch (Exception e) {
            }
            try {
                if (format != null) {
                    format.close();
                }
            } catch (Exception e) {
            }

        }
    }
}