package com.gc.nfc.ui;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.os.Bundle;
import android.widget.TextView;
import android.widget.Toast;

import com.gc.nfc.R;
import com.gc.nfc.base.BaseNfcActivity;

import java.nio.charset.Charset;
import java.util.Locale;

public class WriteTextActivity extends BaseNfcActivity {
    private String mText = "hello!"; //
    TextView textView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_write_text);
    }

    @SuppressLint("SetTextI18n")
    @Override
    public void onNewIntent(Intent intent) {
        if (mText == null)
            return;
        textView = (TextView)findViewById(R.id.data_show);
        textView.setText(this.getResources().getString(R.string.will_write_text) + mText);
        //Get tag object
        Tag detectedTag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
        NdefMessage ndefMessage = new NdefMessage(
                new NdefRecord[]{createTextRecord(mText)});
        boolean result = writeTag(ndefMessage, detectedTag);
        if (result) {
            Toast.makeText(this, this.getResources().getString(R.string.write_success), Toast.LENGTH_SHORT).show();
        } else {
            Toast.makeText(this, this.getResources().getString(R.string.write_failed), Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * Creating nDef text data
     *
     * @param text
     * @return
     */
    public static NdefRecord createTextRecord(String text) {
        byte[] langBytes = Locale.CHINA.getLanguage().getBytes(Charset.forName("US-ASCII"));
        Charset utfEncoding = Charset.forName("UTF-8");
        //Convert text to UTF-8 format
        byte[] textBytes = text.getBytes(utfEncoding);
        //Set the highest bit of status byte encoding to 0
        int utfBit = 0;
        //Define status byte
        char status = (char) (utfBit + langBytes.length);
        byte[] data = new byte[1 + langBytes.length + textBytes.length];
        //To set the first status byte, first convert the status code to a byte
        data[0] = (byte) status;
        //Set the language code, use the array copy method, copy from 0 to data, copy to 1 to 1 of data langBytes.length The location of
        System.arraycopy(langBytes, 0, data, 1, langBytes.length);
        //Set the text byte, use the array copy method, copy from 0 to data, copy to 1 of data+ langBytes.length reach textBytes.length The location of
        System.arraycopy(textBytes, 0, data, 1 + langBytes.length, textBytes.length);
        //Passing in the ndefrecord object by byte
        //NdefRecord.RTD_ Text: incoming type read / write
        NdefRecord ndefRecord = new NdefRecord(NdefRecord.TNF_WELL_KNOWN,
                NdefRecord.RTD_TEXT, new byte[0], data);
        return ndefRecord;
    }

    /**
     * write data
     *
     * @param ndefMessage Create good NDEF text data
     * @param tag         labal
     * @return
     */
    public static boolean writeTag(NdefMessage ndefMessage, Tag tag) {
        Ndef ndef = Ndef.get(tag);
        try {
            ndef.connect();
            ndef.writeNdefMessage(ndefMessage);
            return true;
        } catch (Exception e) {
        } finally {
            try {
                ndef.close();
            } catch (Exception e) {
            }
        }
        return false;
    }
}
